/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230425
********************************************************************************/
/********************************INCLUDES*************************************/
#include "fvr.h"
#include <stdio.h>

/****************************************************************
//Funtion : GPIo_Init
//Input : None
//Output : None
// Description : GPIO初始化
****************************************************************/
void GPIO_INIT(void)
{
	//关闭开漏
	PAOD = 0X00;
	PBOD = 0X00;
	//关闭上拉电阻
	PAPU = 0XFF;
	PBPU = 0XFF;
	//关闭下拉电阻
	PAPD = 0XFF;
	PBPD = 0XFF;
	//IO设置为输出模式
	TRISA=0X00;
	TRISB=0X00;
	//输入输出初始化为低电平
	PORTA=0X00;
	PORTB=0X00;

}

/****************************************************************
//Funtion : FVR_Cfg
//Input : sel Mode
//Output : None
//Description : 输入通道选择  放大倍数选择和模块使能和输出使能
****************************************************************/
//每次都需要选择同相端
//Sel   :1-VREF1P0,2-1/4VDD,3-NTC,4-DACOUT
//Mode<4:3>:0-1倍,1-1倍,2-2倍,3-3倍
//Mode<5>:  0-关闭FVR,1-使能FVR
//Mode<6>:  0-不输出FVR,1-输出FVR（PB3）
void FVR_Cfg(unsigned char Sel,unsigned char Mode)
{

	if ((Mode&0X20)==0X00)
	{
		FVRCON0=0X00;
	}
	else
	{

		FVRCON0=0X20;
		if ((Mode&0X40)==0X00)
		{
			FVROUTEN=0;
		}
		else
		{
			FVROUTEN=1;
			TRISB3=1;
			// PB3PU=1;
			// PB3PD=1;
			PB3AEN=1;  //PB3配置为模拟
		}

		Sel&=0X07;//通道选择
		Mode&=0X18;//放大倍数选择
		FVRCON0|=Mode;
		FVRCON0|=Sel;
		__delay_us(500);
	}

}

